<?php
// Expect: $orders (array), $orderby (string), $order (string), $page (int), $total_pages (int), $total_orders (int)
if (!isset($orders) || !is_array($orders)) $orders = [];
if (!isset($orderby)) $orderby = 'createdAt';
if (!isset($order)) $order = 'DESC';
if (!isset($page)) $page = 1;
if (!isset($total_pages)) $total_pages = 1;
if (!isset($total_orders)) $total_orders = 0;
?>
<div class="wrap">
    <h1>Product Orders (<?php echo esc_html($total_orders); ?> total)</h1>
    
    <?php if (isset($_GET['updated'])): ?>
        <div class="notice notice-success"><p>Order status updated successfully!</p></div>
    <?php endif; ?>
    
    <?php if (isset($_GET['deleted'])): ?>
        <div class="notice notice-success"><p>Record(s) deleted.</p></div>
    <?php endif; ?>
    
    <?php if (isset($_GET['bulk_deleted'])): ?>
        <div class="notice notice-success"><p>Record(s) deleted.</p></div>
    <?php endif; ?>
    
    <?php if (isset($_GET['all_deleted'])): ?>
        <div class="notice notice-success"><p>Record(s) deleted.</p></div>
    <?php endif; ?>
    
    <div class="tablenav top">
        <div class="alignleft actions">
            <label for="orderby-select">Sort by:</label>
            <select id="orderby-select" onchange="window.location.href='<?php echo admin_url('admin.php?page=cardano-pay-orders'); ?>&orderby='+this.value+'&order=<?php echo $order; ?>&paged=<?php echo $page; ?>'">
                <option value="createdAt" <?php selected($orderby, 'createdAt'); ?>>Order Date</option>
                <option value="orderId" <?php selected($orderby, 'orderId'); ?>>Order ID</option>
                <option value="lastName" <?php selected($orderby, 'lastName'); ?>>Last Name</option>
                <option value="productName" <?php selected($orderby, 'productName'); ?>>Product Name</option>
                <option value="country" <?php selected($orderby, 'country'); ?>>Country</option>
            </select>
            <a href="<?php echo admin_url('admin.php?page=cardano-pay-orders'); ?>&orderby=<?php echo $orderby; ?>&order=<?php echo $order === 'DESC' ? 'ASC' : 'DESC'; ?>&paged=<?php echo $page; ?>" class="button">
                <?php echo $order === 'DESC' ? '↑ Ascending' : '↓ Descending'; ?>
            </a>
        </div>
        <div class="alignright actions">
            <a href="<?php echo wp_nonce_url(admin_url('admin.php?page=cardano-pay-orders&export_csv=1'), 'export_csv_orders'); ?>" class="button">Export CSV</a>
        </div>
    </div>

    <form method="post" id="orders-form">
        <?php wp_nonce_field('bulk_delete_orders'); ?>
        <div class="tablenav top">
            <div class="alignleft actions bulkactions">
                <select name="action" id="bulk-action-selector-top">
                    <option value="-1">Bulk Actions</option>
                    <option value="delete">Delete</option>
                </select>
                <input type="submit" id="doaction" class="button action" value="Apply">
            </div>
        </div>

        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <td class="manage-column column-cb check-column">
                        <input type="checkbox" id="cb-select-all-1" onclick="toggleAllCheckboxes(this)">
                    </td>
                    <th>Order ID</th>
                    <th>Date</th>
                    <th>Customer</th>
                    <th>Email</th>
                    <th>Product</th>
                    <th>Quantity</th>
                    <th>Total (USD)</th>
                    <th>Total (ADA)</th>
                    <th>Country</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($orders)): ?>
                    <tr>
                        <td colspan="12" style="text-align: center; padding: 20px;">
                            No orders found. Orders will appear here when customers complete purchases.
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($orders as $order): ?>
                    <tr>
                        <th class="check-column">
                            <input type="checkbox" name="selected_orders[]" value="<?php echo esc_attr($order['orderId']); ?>">
                        </th>
                        <td><strong><?php echo esc_html($order['orderId']); ?></strong></td>
                        <td><?php echo esc_html(date('M j, Y g:i A', strtotime($order['orderDate']))); ?></td>
                        <td><?php echo esc_html($order['firstName'] . ' ' . $order['lastName']); ?></td>
                        <td><?php echo esc_html($order['email']); ?></td>
                        <td>
                            <strong><?php echo esc_html($order['productName']); ?></strong><br>
                            <small>ID: <?php echo esc_html($order['productId']); ?></small>
                        </td>
                        <td><?php echo esc_html($order['quantity']); ?></td>
                        <td>$<?php echo esc_html(number_format($order['orderTotalUsd'], 2)); ?></td>
                        <td><?php echo esc_html(number_format($order['orderTotalAda'], 6)); ?> ADA</td>
                        <td><?php echo esc_html($order['country']); ?></td>
                        <td>
                            <form method="post" style="display: inline;">
                                <?php wp_nonce_field('update_order_status'); ?>
                                <input type="hidden" name="update_status" value="1">
                                <input type="hidden" name="order_id" value="<?php echo esc_attr($order['orderId']); ?>">
                                <select name="status" onchange="this.form.submit()" style="width: 100px;">
                                    <option value="pending" <?php selected($order['status'], 'pending'); ?>>Pending</option>
                                    <option value="processing" <?php selected($order['status'], 'processing'); ?>>Processing</option>
                                    <option value="shipped" <?php selected($order['status'], 'shipped'); ?>>Shipped</option>
                                    <option value="delivered" <?php selected($order['status'], 'delivered'); ?>>Delivered</option>
                                    <option value="cancelled" <?php selected($order['status'], 'cancelled'); ?>>Cancelled</option>
                                </select>
                            </form>
                        </td>
                        <td>
                            <a href="#" class="button button-small" onclick="showOrderDetails('<?php echo esc_js($order['orderId']); ?>')">View Details</a>
                            <a href="<?php echo admin_url('admin.php?page=cardano-pay-orders&delete_order=' . $order['orderId']); ?>" 
                               class="button button-small" 
                               onclick="return confirm('Are you sure you want to delete this order?');">Delete</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </form>

    <?php if ($total_pages > 1): ?>
    <div class="tablenav bottom">
        <div class="tablenav-pages">
            <span class="displaying-num"><?php echo esc_html($total_orders); ?> items</span>
            <span class="pagination-links">
                <?php if ($page > 1): ?>
                    <a class="first-page button" href="<?php echo admin_url('admin.php?page=cardano-pay-orders&paged=1&orderby=' . $orderby . '&order=' . $order); ?>">«</a>
                    <a class="prev-page button" href="<?php echo admin_url('admin.php?page=cardano-pay-orders&paged=' . ($page - 1) . '&orderby=' . $orderby . '&order=' . $order); ?>">‹</a>
                <?php endif; ?>
                
                <span class="paging-input">
                    <label for="current-page-selector" class="screen-reader-text">Current Page</label>
                    <input class="current-page" id="current-page-selector" type="text" name="paged" value="<?php echo esc_attr($page); ?>" size="3" aria-describedby="table-paging">
                    <span class="tablenav-paging-text"> of <span class="total-pages"><?php echo esc_html($total_pages); ?></span></span>
                </span>
                
                <?php if ($page < $total_pages): ?>
                    <a class="next-page button" href="<?php echo admin_url('admin.php?page=cardano-pay-orders&paged=' . ($page + 1) . '&orderby=' . $orderby . '&order=' . $order); ?>">›</a>
                    <a class="last-page button" href="<?php echo admin_url('admin.php?page=cardano-pay-orders&paged=' . $total_pages . '&orderby=' . $orderby . '&order=' . $order); ?>">»</a>
                <?php endif; ?>
            </span>
        </div>
    </div>
    <?php endif; ?>

    <div class="tablenav bottom">
        <div class="alignleft actions">
            <form method="post" style="display: inline;">
                <?php wp_nonce_field('delete_all_orders'); ?>
                <input type="submit" name="delete_all_orders" class="button" value="Delete All Orders" 
                       onclick="return confirm('Are you sure you want to delete ALL orders? This action cannot be undone!');">
            </form>
        </div>
    </div>
</div>

<!-- Order Details Modal -->
<div id="order-details-modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999;">
    <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 30px; border-radius: 8px; max-width: 800px; max-height: 90vh; overflow-y: auto; box-shadow: 0 4px 20px rgba(0,0,0,0.3);">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; border-bottom: 2px solid #f0f0f0; padding-bottom: 15px;">
            <h2 style="margin: 0; color: #333;">Order Details</h2>
            <button onclick="closeOrderDetails()" class="button" style="background: #dc3545; color: white; border: none; padding: 8px 16px; border-radius: 4px; cursor: pointer;">✕ Close</button>
        </div>
        <div id="order-details-content" style="font-family: Arial, sans-serif; line-height: 1.6;">
            <div style="text-align: center; padding: 40px;">
                <div class="spinner" style="border: 4px solid #f3f3f3; border-top: 4px solid #3498db; border-radius: 50%; width: 40px; height: 40px; animation: spin 1s linear infinite; margin: 0 auto;"></div>
                <p style="margin-top: 15px; color: #666;">Loading order details...</p>
            </div>
        </div>
    </div>
</div>

<style>
@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
.order-detail-section {
    margin-bottom: 25px;
    padding: 15px;
    background: #f8f9fa;
    border-radius: 6px;
    border-left: 4px solid #007cba;
}
.order-detail-section h4 {
    margin: 0 0 10px 0;
    color: #333;
    font-size: 16px;
}
.order-detail-row {
    display: flex;
    margin-bottom: 8px;
}
.order-detail-label {
    font-weight: bold;
    min-width: 150px;
    color: #555;
}
.order-detail-value {
    color: #333;
    flex: 1;
}
.transaction-hash {
    font-family: monospace;
    background: #e9ecef;
    padding: 4px 8px;
    border-radius: 4px;
    word-break: break-all;
}
.explorer-link {
    color: #007cba;
    text-decoration: none;
    font-weight: bold;
}
.explorer-link:hover {
    text-decoration: underline;
}
</style>

<script>
function showOrderDetails(orderId) {
    // Show modal with loading state
    document.getElementById('order-details-modal').style.display = 'block';
    
    // Make AJAX call to get order details
    const formData = new FormData();
    formData.append('action', 'cardano_get_order_details');
    formData.append('nonce', '<?php echo wp_create_nonce('cardanocheckoutnonce'); ?>');
    formData.append('order_id', orderId);
    
    fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            displayOrderDetails(data.data);
        } else {
            document.getElementById('order-details-content').innerHTML = 
                '<div style="text-align: center; padding: 40px; color: #dc3545;">' +
                '<h3>Error Loading Order Details</h3>' +
                '<p>' + (data.data?.message || 'Unknown error occurred') + '</p>' +
                '</div>';
        }
    })
    .catch(error => {
        console.error('Error fetching order details:', error);
        document.getElementById('order-details-content').innerHTML = 
            '<div style="text-align: center; padding: 40px; color: #dc3545;">' +
            '<h3>Error Loading Order Details</h3>' +
            '<p>Failed to load order details. Please try again.</p>' +
            '</div>';
    });
}

function displayOrderDetails(order) {
    const content = `
        <div class="order-detail-section">
            <h4>📋 Order Information</h4>
            <div class="order-detail-row">
                <span class="order-detail-label">Order ID:</span>
                <span class="order-detail-value"><strong>${order.orderId}</strong></span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">Order Date:</span>
                <span class="order-detail-value">${order.orderDate}</span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">Status:</span>
                <span class="order-detail-value"><span style="background: #28a745; color: white; padding: 2px 8px; border-radius: 12px; font-size: 12px;">${order.status}</span></span>
            </div>
        </div>

        <div class="order-detail-section">
            <h4>👤 Customer Information</h4>
            <div class="order-detail-row">
                <span class="order-detail-label">Name:</span>
                <span class="order-detail-value">${order.firstName} ${order.lastName}</span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">Email:</span>
                <span class="order-detail-value"><a href="mailto:${order.email}">${order.email}</a></span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">Phone:</span>
                <span class="order-detail-value">${order.phone}</span>
            </div>
        </div>

        <div class="order-detail-section">
            <h4>🚚 Shipping Address</h4>
            <div class="order-detail-row">
                <span class="order-detail-label">Address:</span>
                <span class="order-detail-value">${order.shippingAddress1}${order.shippingAddress2 ? ', ' + order.shippingAddress2 : ''}</span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">City:</span>
                <span class="order-detail-value">${order.city}</span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">State/Province:</span>
                <span class="order-detail-value">${order.stateProvince}</span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">Postal Code:</span>
                <span class="order-detail-value">${order.postalCode}</span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">Country:</span>
                <span class="order-detail-value">${order.country}</span>
            </div>
            ${order.specialInstructions ? `
            <div class="order-detail-row">
                <span class="order-detail-label">Special Instructions:</span>
                <span class="order-detail-value">${order.specialInstructions}</span>
            </div>
            ` : ''}
        </div>

        <div class="order-detail-section">
            <h4>🛍️ Product Information</h4>
            <div class="order-detail-row">
                <span class="order-detail-label">Product Name:</span>
                <span class="order-detail-value"><strong>${order.productName}</strong></span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">Product ID:</span>
                <span class="order-detail-value">${order.productId}</span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">Quantity:</span>
                <span class="order-detail-value">${order.quantity}</span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">Total (USD):</span>
                <span class="order-detail-value"><strong>$${order.orderTotalUsd}</strong></span>
            </div>
            <div class="order-detail-row">
                <span class="order-detail-label">Total (ADA):</span>
                <span class="order-detail-value"><strong>${order.orderTotalAda} ADA</strong></span>
            </div>
        </div>

        <div class="order-detail-section">
            <h4>💳 Payment Information</h4>
            <div class="order-detail-row">
                <span class="order-detail-label">Transaction Hash:</span>
                <span class="order-detail-value">
                    <span class="transaction-hash">${order.txHash}</span>
                </span>
            </div>
            ${order.txHash !== 'N/A' ? `
            <div class="order-detail-row">
                <span class="order-detail-label">View on Explorer:</span>
                <span class="order-detail-value">
                    <a href="https://cardanoscan.io/transaction/${order.txHash}" target="_blank" class="explorer-link">
                        🔗 Open in Cardanoscan.io
                    </a>
                </span>
            </div>
            ` : ''}
        </div>
    `;
    
    document.getElementById('order-details-content').innerHTML = content;
}

function closeOrderDetails() {
    document.getElementById('order-details-modal').style.display = 'none';
}

// Close modal when clicking outside
document.getElementById('order-details-modal').onclick = function(e) {
    if (e.target === this) {
        closeOrderDetails();
    }
}

function toggleAllCheckboxes(selectAllCheckbox) {
    const checkboxes = document.querySelectorAll('input[name="selected_orders[]"]');
    checkboxes.forEach(checkbox => {
        checkbox.checked = selectAllCheckbox.checked;
    });
}

// Handle bulk actions
document.getElementById('doaction').addEventListener('click', function(e) {
    const action = document.getElementById('bulk-action-selector-top').value;
    const selectedOrders = document.querySelectorAll('input[name="selected_orders[]"]:checked');
    
    if (action === 'delete' && selectedOrders.length > 0) {
        if (confirm('Are you sure you want to delete the selected orders?')) {
            // Submit the form
            document.getElementById('orders-form').submit();
        } else {
            e.preventDefault();
        }
    } else if (action === '-1') {
        alert('Please select an action.');
        e.preventDefault();
    } else if (selectedOrders.length === 0) {
        alert('Please select at least one order.');
        e.preventDefault();
    }
});
</script>
