<?php
if (!isset($message)) $message = '';
?>
<div class="wrap">
    <h1>Product Manager Page</h1>
    <?php if (!empty($message)) : ?>
        <div class="updated notice">
            <p><?php echo esc_html($message); ?></p>
        </div>
    <?php endif; ?>

    <form method="post">
        <?php wp_nonce_field('saveproductcardanopay'); ?>
        <table class="form-table">
            <tr>
                <th>Product ID</th>
                <td><input type="text" name="ProductID" style="width:40%" placeholder="Leave empty for auto-generated ID"></td>
            </tr>
            <tr>
                <th>Product Image</th>
                <td>
                    <input type="text" id="ProductImage" name="ProductImage" value="" style="width:40%">
                    <input type="button" value="Select Image" class="button" id="ProductImageupload">
                    <div id="ProductImagepreview"></div>
                    <script>
                        jQuery(document).ready(function($){
                            $('#ProductImageupload').on('click', function(e){
                                e.preventDefault();
                                var image_frame;
                                if(window.image_frame){
                                    window.image_frame.open();
                                    return;
                                }
                                window.image_frame = wp.media({
                                    title: 'Select Product Image',
                                    multiple: false,
                                    library: { type: 'image' }
                                });
                                window.image_frame.on('close', function(){
                                    var selection = window.image_frame.state().get('selection');
                                    var gallery_ids = [];
                                    var myindex = 0;
                                    selection.each(function(attachment){
                                        gallery_ids[myindex] = attachment.attributes.url;
                                        myindex++;
                                    });
                                    var ids = gallery_ids.join(',');
                                    $('#ProductImage').val(ids);
                                    $('#ProductImagepreview').html('<img src="'+ids+'" style="max-width:100px;">');
                                });
                                window.image_frame.on('open',function(){
                                    var selection = window.image_frame.state().get('selection');
                                    var ids = $('#ProductImage').val().split(',');
                                    ids.forEach(function(id){
                                        var attachment = wp.media.attachment(id);
                                        attachment.fetch();
                                        selection.add(attachment ? attachment : null);
                                    });
                                });
                                window.image_frame.open();
                            });
                        });
                    </script>
                </td>
            </tr>
            <tr>
                <th>Product Name</th>
                <td><input type="text" name="ProductName" required style="width:40%"></td>
            </tr>
            <tr>
                <th>Product Description</th>
                <td><textarea name="ProductDescription" required style="width:40%;height:100px"></textarea></td>
            </tr>
            <tr>
                <th>Product Height</th>
                <td><input type="text" name="ProductHeight" required style="width:40%"></td>
            </tr>
            <tr>
                <th>Product Width</th>
                <td><input type="text" name="ProductWidth" required style="width:40%"></td>
            </tr>
            <tr>
                <th>Product Price</th>
                <td><input type="number" name="ProductPrice" value="0" step="0.01" min="0" required style="width:10%"></td>
            </tr>
            <tr>
                <th>Quantity Limit Per Customer</th>
                <td><input type="number" name="QuantityLimitPerCustomer" value="1" min="1" required style="width:10%"></td>
            </tr>
        </table>
        <p class="submit">
            <input type="submit" name="saveproduct" class="button-primary" value="Add Product">
        </p>
    </form>
</div>