<?php
// Requires: $products (array), $slots_used (int), $admin_url (string)
if (!isset($products) || !is_array($products)) $products = [];
if (!isset($slots_used)) $slots_used = 0;
if (!isset($admin_url)) $admin_url = admin_url();
?>
<div class="wrap">
    <?php if (isset($_GET['deleted']) && $_GET['deleted'] == '1'): ?>
        <div class="notice notice-success"><p>Record(s) deleted.</p></div>
    <?php endif; ?>
    <h3>
        You have <span style="color:#e56958;"><?php echo esc_html($slots_used); ?></span> of 10 inventory slots remaining.
    </h3>

    <form method="POST" id="bulk-delete-form">
        <?php wp_nonce_field('bulkdeleteproducts'); ?>
        <table class="widefat fixed">
            <thead>
                <tr>
                    <th><input type="checkbox" id="select-all"></th>
                    <th>Product ID</th>
                    <th>Product Image</th>
                    <th>Product Name</th>
                    <th>Product Description</th>
                    <th>Product Height</th>
                    <th>Product Width</th>
                    <th>Product Price</th>
                    <th>Qty Limit</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($products as $product): ?>
                    <tr>
                        <td>
                            <input type="checkbox" name="selectedproducts[]" value="<?php echo esc_attr($product['ProductID']); ?>">
                        </td>
                        <td>
                            <strong><?php echo esc_html($product['ProductID']); ?></strong>
                        </td>
                        <td>
                            <?php if (!empty($product['ProductImage'])): ?>
                                <img src="<?php echo esc_url($product['ProductImage']); ?>" 
                                     style="max-width:60px;max-height:60px; border-radius: 4px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                            <?php else: ?>
                                <span style="color: #666; font-style: italic;">No image</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <strong><?php echo esc_html($product['ProductName']); ?></strong>
                        </td>
                        <td>
                            <div style="max-width: 200px; max-height: 60px; overflow: hidden; text-overflow: ellipsis; line-height: 1.4;">
                                <?php echo esc_html($product['ProductDescription']); ?>
                            </div>
                        </td>
                        <td>
                            <span style="background: #f1f1f1; padding: 2px 6px; border-radius: 3px; font-size: 12px;">
                                <?php echo esc_html($product['ProductHeight']); ?>
                            </span>
                        </td>
                        <td>
                            <span style="background: #f1f1f1; padding: 2px 6px; border-radius: 3px; font-size: 12px;">
                                <?php echo esc_html($product['ProductWidth']); ?>
                            </span>
                        </td>
                        <td>
                            <strong style="color: #0073aa; font-size: 16px;">
                                $<?php echo esc_html(number_format($product['ProductPrice'], 2)); ?>
                            </strong>
                        </td>
                        <td>
                            <span style="background: #f1f1f1; padding: 2px 6px; border-radius: 3px; font-size: 12px; font-weight: bold;">
                                <?php echo esc_html($product['QuantityLimitPerCustomer'] ?? '1'); ?>
                            </span>
                        </td>
                        <td>
                            <a href="<?php echo esc_url(admin_url('admin.php?page=cardano-pay-inventory-list&deleteitem=' . $product['ProductID'])); ?>" 
                               class="button button-small" 
                               onclick="return confirm('Are you sure you want to delete this product? This action cannot be undone.');"
                               style="color: #d63638;">
                                Delete
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </form>
    
    <?php if (!empty($products)): ?>
    <div style="margin-top: 20px;">
        <button type="button" class="button button-secondary" onclick="document.getElementById('bulk-delete-form').submit();" 
                style="color: #d63638;">
            Delete Selected Products
        </button>
    </div>
    <?php endif; ?>
</div>
<script>
document.getElementById('select-all').onclick = function() {
    var boxes = document.querySelectorAll('input[name="selectedproducts[]"]');
    for (let i = 0; i < boxes.length; i++) {
        boxes[i].checked = this.checked;
    }
};

// Handle bulk delete with confirmation
document.addEventListener('DOMContentLoaded', function() {
    const bulkDeleteBtn = document.querySelector('button[onclick*="bulk-delete-form"]');
    if (bulkDeleteBtn) {
        bulkDeleteBtn.onclick = function(e) {
            e.preventDefault();
            const checkedBoxes = document.querySelectorAll('input[name="selectedproducts[]"]:checked');
            if (checkedBoxes.length === 0) {
                alert('Please select at least one product to delete.');
                return;
            }
            if (confirm('Are you sure you want to delete ' + checkedBoxes.length + ' selected product(s)? This action cannot be undone.')) {
                document.getElementById('bulk-delete-form').submit();
            }
        };
    }
});
</script>