<?php
// Email receipt template for product orders
// Variables expected: $order (array with order data)

if (!isset($order) || !is_array($order)) {
    $order = [];
}

$orderId = $order['orderId'] ?? 'N/A';
$orderDate = $order['orderDate'] ?? 'N/A';
$firstName = $order['firstName'] ?? '';
$lastName = $order['lastName'] ?? '';
$email = $order['email'] ?? '';
$phone = $order['phone'] ?? '';
$shippingAddress1 = $order['shippingAddress1'] ?? '';
$shippingAddress2 = $order['shippingAddress2'] ?? '';
$city = $order['city'] ?? '';
$stateProvince = $order['stateProvince'] ?? '';
$postalCode = $order['postalCode'] ?? '';
$country = $order['country'] ?? '';
$specialInstructions = $order['specialInstructions'] ?? '';
$productId = $order['productId'] ?? '';
$productName = $order['productName'] ?? '';
$quantity = $order['quantity'] ?? 1;
$orderTotalUsd = $order['orderTotalUsd'] ?? 0;
$orderTotalAda = $order['orderTotalAda'] ?? 0;
$status = $order['status'] ?? 'pending';
$txHash = $order['txHash'] ?? '';

// Format order date
$formattedDate = date('F j, Y \a\t g:i A', strtotime($orderDate));

// Build shipping address
$shippingAddress = $shippingAddress1;
if (!empty($shippingAddress2)) {
    $shippingAddress .= ', ' . $shippingAddress2;
}
$shippingAddress .= '<br>' . $city . ', ' . $stateProvince . ' ' . $postalCode . '<br>' . $country;
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Confirmation</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #676767; margin: 0; padding: 0; }
        .email-container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #2DB0B8; color:#fefefc; padding: 20px; border-radius: 8px; margin-bottom: 20px; }
        .section { margin-bottom: 25px; }
        .section h3 { color: #24A4BD	; border-bottom: 2px solid #f7f1e9; padding-bottom: 5px; }
        .tx-hash { font-family: monospace; background: #e9ecef; padding: 8px; border-radius: 4px; word-break: break-all; }
        .explorer-link { color: #007cba; text-decoration: none; font-weight: bold; }
        .explorer-link:hover { text-decoration: underline; }
        .total-section { background: #f8f9fa; padding: 15px; border-radius: 5px; }
        .footer { margin: 20px 0 20px 0; padding: 0 0 20px 0; border-top: 1px solid #ddd; font-size: 14px; text-align: center; color: #666; }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <h1 style="text-align: center;">Your Art Collectors List Order</h1>
        </div>

        <p>Hi <strong><?php echo esc_html($firstName . ' ' . $lastName); ?></strong>!</p>

      <p>Below, see the details of the order you placed in the <em>Addicted to Detail</em> Drop Shop. Processing time takes about 1 week.</p>

        <?php if (!empty($txHash)): ?>
        <div class="section">
            <h3>Payment Confirmation</h3>
           <p><strong>View your order on the Cardano Blockchain:</strong> <a href="https://cardanoscan.io/transaction/<?php echo esc_html($txHash); ?>" class="explorer-link" target="_blank">🔗 Open in Cardanoscan.io</a></p>
            <p><strong>Transaction Hash:</strong></p>
            <p class="tx-hash"><?php echo esc_html($txHash); ?></p>
           
        </div>
        <?php endif; ?>

        <div class="section">
            <h3>📋 Order Details</h3>
            <p><strong>Order Number:</strong> <?php echo esc_html($orderId); ?></p>
            <p><strong>Order Date:</strong> <?php echo esc_html($formattedDate); ?></p>
            <p><strong>Status:</strong> Processing Order</p>
            <p><strong>Product:</strong> <?php echo esc_html($productName); ?></p>
            <p><strong>Quantity:</strong> <?php echo esc_html($quantity); ?></p>
        </div>

        <div class="section">
            <h3>Order Total</h3>
            <div class="total-section">
                <p><strong>Total (USD):</strong> $<?php echo esc_html(number_format($orderTotalUsd, 2)); ?></p>
                <p><strong>Total (ADA):</strong> <?php echo esc_html(number_format($orderTotalAda, 6)); ?> ADA</p>
            </div>
        </div>

        <div class="section">
            <h3>Shipping Information</h3>
            <p><strong>Name:</strong> <?php echo esc_html($firstName . ' ' . $lastName); ?></p>
            <p><strong>Email:</strong> <?php echo esc_html($email); ?></p>
            <p><strong>Phone:</strong> <?php echo esc_html($phone); ?></p>
            <p><strong>Address:</strong><br><?php echo $shippingAddress; ?></p>
        </div>

        <?php if (!empty($specialInstructions)): ?>
        <div class="section">
            <h3>📝 Special Instructions</h3>
            <p><?php echo esc_html($specialInstructions); ?></p>
        </div>
        <?php endif; ?>

        <div class="section">
            <h3>📋 Next Steps</h3>
            <ol>
                <li>Your order will be processed within 7 business days.</li>
                <li>You will receive a shipping confirmation email once your order ships.</li>
                <li>If you have any questions, please contact me with your Order Number: <strong><?php echo esc_html($orderId); ?></strong></li>
            </ol>
        </div>

        <div class="footer">
            <h3>Thank you for your order!</h3>
            <hr>
            <p><em>This is an automated email. Please do not reply to this message.<br>
            For support, contact PB_Anvil through GitHub or at umbrella.lol.</em></p>
        </div>
    </div>
</body>
</html>




