<?php
// Variables expected: $atts['productname'], $atts['price'], $atts['merchantaddress'], $prod (object|null), $atts['productid']
if (!isset($atts) || !is_array($atts)) $atts = [];
if (!isset($atts['productname'])) $atts['productname'] = '';
if (!isset($atts['price'])) $atts['price'] = '';
if (!isset($atts['merchantaddress'])) $atts['merchantaddress'] = '';
if (!isset($atts['productid']) && isset($atts['product-id'])) $atts['productid'] = $atts['product-id'];
if (!isset($atts['productid'])) $atts['productid'] = '';
if (!isset($prod)) $prod = null;

// Debug logging for merchant address
if (WP_DEBUG && WP_DEBUG_LOG) {
    error_log('Cardano Pay Debug - Merchant Address: ' . $atts['merchantaddress']);
}

// Get product details for modal
$product_id = $atts['productid'];
$product_name = $prod ? $prod->ProductName : $atts['productname'];
$product_price = $prod ? floatval($prod->ProductPrice) : floatval($atts['price']);
$product_image = $prod ? $prod->ProductImage : '';
$product_description = $prod ? $prod->ProductDescription : '';
$quantity_limit = $prod ? $prod->QuantityLimitPerCustomer : 1;

// Debug output (only in development)
if (WP_DEBUG && WP_DEBUG_LOG) {
    error_log('Cardano Pay Debug - Product ID: ' . $product_id);
    error_log('Cardano Pay Debug - Product Object: ' . print_r($prod, true));
    error_log('Cardano Pay Debug - Product Name: ' . $product_name);
    error_log('Cardano Pay Debug - Product Price: ' . $product_price);
    error_log('Cardano Pay Debug - Product Image: ' . $product_image);
}
?>

<div id="cardano-checkout-widget" class="cardano-checkout">
    <!-- Simple Price Display -->
    <div class="product-price">
        <div class="usd-price">$<?php echo esc_html(number_format($product_price, 2)); ?> USD</div>
        <div class="ada-price"><?php 
            // Get live ADA price
            $ada_price = CardanoMintPay\Models\MintModel::getNFTPrice();
            $ada_amount = $product_price / $ada_price;
            echo esc_html(number_format($ada_amount, 6)); 
        ?> ADA</div>
    </div>

    <!-- Buy Now Button -->
    <button type="button" id="cardano-buy-now-btn" class="cardano-buy-now-button" 
            data-product-id="<?php echo esc_attr($product_id); ?>"
            data-product-name="<?php echo esc_attr($product_name); ?>"
            data-product-price="<?php echo esc_attr($product_price); ?>"
            data-product-image="<?php echo esc_attr($product_image); ?>"
            data-product-description="<?php echo esc_attr($product_description); ?>"
            data-quantity-limit="<?php echo esc_attr($quantity_limit); ?>"
            data-merchant-address="<?php echo esc_attr($atts['merchantaddress']); ?>">
        BUY NOW
    </button>
</div>

<!-- Multi-Step Checkout Modal -->
<div id="cardano-checkout-modal" class="cardano-modal" style="display: none;">
    <div class="cardano-modal-content">
        <div class="cardano-modal-header">
            <h2>Complete Your Order</h2>
            <span class="cardano-modal-close">&times;</span>
        </div>
        
        <div class="cardano-modal-body">
            <!-- Progress Steps -->
            <div class="checkout-steps">
                <div class="step active" data-step="1">
                    <span class="step-number">1</span>
                    <span class="step-title">Contact Details</span>
                </div>
                <div class="step" data-step="2">
                    <span class="step-number">2</span>
                    <span class="step-title">Shipping Details</span>
                </div>
                <div class="step" data-step="3">
                    <span class="step-number">3</span>
                    <span class="step-title">Order Review</span>
                </div>
            </div>

            <form id="cardano-checkout-form" method="post">
                <!-- Step 1: Contact Details -->
                <div class="checkout-step" id="step-1">
                    <h3>Contact Information</h3>
                    <div class="form-row">
                        <div class="form-group">
                            <label for="first_name">First Name *</label>
                            <input type="text" id="first_name" name="first_name" required>
                        </div>
                        <div class="form-group">
                            <label for="last_name">Last Name *</label>
                            <input type="text" id="last_name" name="last_name" required>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label for="email">Email *</label>
                            <input type="email" id="email" name="email" required>
                        </div>
                        <div class="form-group">
                            <label for="phone">Phone *</label>
                            <input type="tel" id="phone" name="phone" placeholder="(Include country code)" required>
                        </div>
                    </div>
                    <button type="button" class="btn-next" onclick="nextStep(2)">Continue to Shipping</button>
                </div>

                <!-- Step 2: Shipping Details -->
                <div class="checkout-step" id="step-2" style="display: none;">
                    <h3>Shipping Information</h3>
                    <div class="form-group">
                        <label for="shipping_address_1">Street Address *</label>
                        <input type="text" id="shipping_address_1" name="shipping_address_1" required>
                    </div>
                    <div class="form-group">
                        <label for="shipping_address_2">Apartment or Suite #</label>
                        <input type="text" id="shipping_address_2" name="shipping_address_2">
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label for="city">City *</label>
                            <input type="text" id="city" name="city" required>
                        </div>
                        <div class="form-group">
                            <label for="state_province">State/Province/Region *</label>
                            <input type="text" id="state_province" name="state_province" required>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label for="postal_code">Postal/ZIP Code *</label>
                            <input type="text" id="postal_code" name="postal_code" required>
                        </div>
                        <div class="form-group">
                            <label for="country">Country *</label>
                            <input type="text" id="country" name="country" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="special_instructions">Special Instructions</label>
                        <textarea id="special_instructions" name="special_instructions" placeholder="Place any special delivery instructions here."></textarea>
                    </div>
                    <div class="step-buttons">
                        <button type="button" class="btn-prev" onclick="prevStep(1)">Back to Contact</button>
                        <button type="button" class="btn-next" onclick="nextStep(3)">Review Order</button>
                    </div>
                </div>

                <!-- Step 3: Order Review -->
                <div class="checkout-step" id="step-3" style="display: none;">
                    <h3>Review Your Order</h3>
                    
                    <!-- Hidden fields for order data -->
                    <input type="hidden" id="order_id" name="order_id">
                    <input type="hidden" id="order_date" name="order_date">
                    <input type="hidden" id="product_id" name="product_id">
                    <input type="hidden" id="merchant_address" name="merchant_address">
                    
                    <div class="order-review">
                        <div class="order-product">
                            <div class="product-image">
                                <img id="review_product_image" src="" alt="">
                            </div>
                            <div class="product-details">
                                <h4 id="review_product_name"></h4>
                                <p id="review_product_description"></p>
                                <div class="quantity-selector">
                                    <label>Quantity:</label>
                                    <select id="review_quantity" name="quantity" onchange="updateOrderTotal()">
                                        <!-- Populated by JavaScript -->
                                    </select>
                                </div>
                                <div class="order-total-display">
                                    <div class="total-usd" id="order_total_usd">$0.00 USD</div>
                                    <div class="total-ada" id="order_total_ada">0.000000 ADA</div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="customer-details">
                            <h4>Customer Information</h4>
                            <p><strong>Name:</strong> <span id="review_customer_name"></span></p>
                            <p><strong>Email:</strong> <span id="review_email"></span></p>
                            <p><strong>Phone:</strong> <span id="review_phone"></span></p>
                        </div>
                        
                        <div class="shipping-details">
                            <h4>Shipping Address</h4>
                            <p id="review_shipping_address"></p>
                        </div>
                    </div>
                    
                    <div class="step-buttons">
                        <button type="button" class="btn-prev" onclick="prevStep(2)">Back to Shipping</button>
                        <button type="submit" class="btn-place-order">PLACE ORDER</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Assets are enqueued by the plugin -->