<?php
namespace CardanoMintPay\Models;

if ( ! defined( 'ABSPATH' ) ) exit;

class TransactionModel {
    private static function table() {
        global $wpdb;
        return $wpdb->prefix . 'cardanopay_transactions';
    }

    public static function insert($args) {
        global $wpdb;
        $data = [
            'tx_hash'    => isset($args['tx_hash']) ? sanitize_text_field($args['tx_hash']) : '',
            'merchant'   => isset($args['merchant']) ? sanitize_text_field($args['merchant']) : '',
            'customer'   => isset($args['customer']) ? sanitize_text_field($args['customer']) : '',
            'usd_price'  => isset($args['usd_price']) ? floatval($args['usd_price']) : 0,
            'ada_amount' => isset($args['ada_amount']) ? floatval($args['ada_amount']) : 0,
            'product'    => isset($args['product']) ? sanitize_text_field($args['product']) : '',
            'meta'       => isset($args['meta']) ? maybe_serialize($args['meta']) : '',
            'created_at' => current_time('mysql', 1)
        ];
        $wpdb->insert(self::table(), $data);
        return $wpdb->insert_id;
    }

    public static function getByHash($tx_hash) {
        global $wpdb;
        return $wpdb->get_row(
            $wpdb->prepare(
                "SELECT * FROM " . self::table() . " WHERE tx_hash = %s",
                $tx_hash
            ),
            ARRAY_A
        );
    }

    public static function listRecent($limit = 10) {
        global $wpdb;
        return $wpdb->get_results(
            $wpdb->prepare(
                "SELECT * FROM " . self::table() . " ORDER BY created_at DESC LIMIT %d",
                $limit
            ),
            ARRAY_A
        );
    }

    public static function updateByHash($tx_hash, $fields) {
        global $wpdb;
        return $wpdb->update(
            self::table(),
            $fields,
            ['tx_hash' => sanitize_text_field($tx_hash)]
        );
    }

    public static function deleteByHash($tx_hash) {
        global $wpdb;
        return $wpdb->delete(
            self::table(),
            ['tx_hash' => sanitize_text_field($tx_hash)]
        );
    }

    public static function installTable() {
        global $wpdb;
        $table = self::table();
        $charset_collate = $wpdb->get_charset_collate();
        $sql = "CREATE TABLE IF NOT EXISTS $table (
            id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
            tx_hash varchar(128) NOT NULL,
            merchant varchar(128) NOT NULL,
            customer varchar(128) NOT NULL,
            usd_price decimal(12,2) NOT NULL DEFAULT 0,
            ada_amount decimal(18,6) NOT NULL DEFAULT 0,
            product varchar(255),
            meta text,
            created_at datetime NOT NULL,
            PRIMARY KEY  (id),
            UNIQUE KEY tx_hash (tx_hash)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
}
