<?php
namespace CardanoMintPay\Models;

class ProductModel {
    private static function getTable() {
        global $wpdb;
        return $wpdb->prefix . 'cardanopayproducts';
    }

    public static function getProductById($productId) {
        global $wpdb;
        $table = self::getTable();
        
        // Debug: Check table name and query
        if (WP_DEBUG && WP_DEBUG_LOG) {
            error_log('ProductModel Debug - Table: ' . $table);
            error_log('ProductModel Debug - Product ID: ' . $productId);
        }
        
        $result = $wpdb->get_row(
            $wpdb->prepare("SELECT * FROM $table WHERE ProductID = %s", sanitize_text_field($productId))
        );
        
        // Debug: Check result
        if (WP_DEBUG && WP_DEBUG_LOG) {
            error_log('ProductModel Debug - Query Result: ' . ($result ? 'FOUND' : 'NOT FOUND'));
            if ($result) {
                error_log('ProductModel Debug - Product Name: ' . $result->ProductName);
            }
        }
        
        return $result;
    }

    public static function listProducts($limit = 10) {
        global $wpdb;
        $table = self::getTable();
        return $wpdb->get_results(
            $wpdb->prepare("SELECT * FROM $table ORDER BY ProductID DESC LIMIT %d", intval($limit)),
            ARRAY_A
        );
    }

    public static function createProduct($data) {
        global $wpdb;
        $table = self::getTable();
        $fields = array(
            'ProductID' => sanitize_text_field($data['ProductID']),
            'ProductImage' => sanitize_text_field($data['ProductImage']),
            'ProductName' => sanitize_text_field($data['ProductName']),
            'ProductDescription' => sanitize_textarea_field($data['ProductDescription']),
            'ProductHeight' => sanitize_text_field($data['ProductHeight']),
            'ProductWidth' => sanitize_text_field($data['ProductWidth']),
            'ProductPrice' => floatval($data['ProductPrice']),
            'QuantityLimitPerCustomer' => intval($data['QuantityLimitPerCustomer']),
        );
        return $wpdb->insert($table, $fields);
    }

    public static function updateProduct($productId, $data) {
        global $wpdb;
        $table = self::getTable();
        $fields = array(
            'ProductImage' => sanitize_text_field($data['ProductImage']),
            'ProductName' => sanitize_text_field($data['ProductName']),
            'ProductDescription' => sanitize_textarea_field($data['ProductDescription']),
            'ProductHeight' => sanitize_text_field($data['ProductHeight']),
            'ProductWidth' => sanitize_text_field($data['ProductWidth']),
            'ProductPrice' => floatval($data['ProductPrice']),
        );
        return $wpdb->update($table, $fields, array('ProductID' => sanitize_text_field($productId)));
    }

    public static function deleteProduct($productId) {
        global $wpdb;
        $table = self::getTable();
        return $wpdb->delete($table, array('ProductID' => sanitize_text_field($productId)));
    }
}
