# Cardano Minting and Payments Wordpress Plugin v3.0

A comprehensive WordPress plugin for Cardano NFT minting with dual-signature security, policy wallet management, IPFS pinning, per-wallet mint limits, CSV whitelist management, and automated CIP-27 royalty tokens.

## Installation

### Step 1: Download & Install the Plugin

1. Download the ZIP file from this repository (Code → Download ZIP)
2. In your WordPress admin, go to **Plugins → Add New → Upload Plugin**
3. Choose the downloaded ZIP file and click **Install Now**
4. Click **Activate** once installed

### Step 2: Get Your API Keys (All Free)

You'll need API keys from three services. Free tiers work for most use cases:

| Service | Purpose | Get Your Key |
|---------|---------|--------------|
| **ADA Anvil** | Transaction building & blockchain submission | [ada-anvil.io/services/api](https://ada-anvil.io/services/api) |
| **Pinata** | IPFS storage for NFT images (optional but recommended) | [pinata.cloud](https://pinata.cloud/) |
| **Blockfrost** | Blockchain queries (used by CardanoPress) | [blockfrost.io](https://blockfrost.io/) |

### Step 3: Configure the Plugin

1. Go to **Cardano Mint → Plugin Setup** in your WordPress admin
2. Enter your Anvil API keys (mainnet and/or preprod testnet)
3. Add your Pinata credentials if using IPFS
4. Set your merchant wallet address for receiving payments
5. Select your network (use Preprod for testing first!)

### Step 4: Create Your First Mint

1. Go to **Cardano Mint → Policy Wallet** and generate a new wallet
2. **IMPORTANT:** Save your 24-word seed phrase immediately - it's only shown once!
3. Go to **Cardano Mint → Mint Manager** to create your first NFT collection
4. Add the shortcode `[cardano-mint mint-id="YOUR_ID"]` to any page

### Requirements

- WordPress 5.0+
- PHP 7.4+

**Required WordPress Plugins:**
- [CardanoPress](https://cardanopress.io/) - Core wallet connection functionality
- [User Access Manager (UAM)](https://wordpress.org/plugins/user-access-manager/) - Access control management
- [User Role Editor](https://wordpress.org/plugins/user-role-editor/) - Role and capability management

## Key Features

### NFT Minting System
- **Collection & Variant System**: Create multi-variant collections (e.g., 20-A, 20-B, 20-C) with weighted rarity
- **Mystery Box / Blind Minting**: Use collection images to hide NFT artwork until reveal
- **Dual-Signature Security**: Customer wallet + policy wallet signatures required
- **CIP-25 Metadata Builder**: Add unlimited custom attributes
- **Weighted Random Selection**: Rarity-based random variant selection

### Policy Wallet Management
- **Secure Generation**: Creates 24-word seed phrase (shown once, encrypted with WordPress salts)
- **Dual-Signature Authority**: Signs all minting transactions alongside customers
- **AES-256-CBC Encryption**: Keys encrypted using WordPress AUTH_KEY and SECURE_AUTH_SALT
- **One-Time Seed Display**: Save immediately - cannot be recovered if lost

### Per-Wallet Mint Limits & Tracking
- **Configurable Limits**: Set maximum mints per wallet (0 = unlimited but tracked)
- **CSV Export**: Download complete mint history with wallet addresses and dates
- **CSV Import (Whitelist)**: Pre-authorize wallets by uploading modified CSV
- **View History Modal**: Real-time tracking of all minters with remaining counts
- **Unique Minters Count**: Track engagement and analytics

### IPFS & Storage
- **Pinata Integration**: Optional IPFS pinning for permanent NFT storage
- **WordPress CDN Fallback**: Works without Pinata using WordPress media library
- **Image Name Limit**: 63 characters max for on-chain metadata compatibility

### Automated Royalty System
- **CIP-27 Royalty Tokens**: Automatically minted with first NFT in policy
- **One Per Policy**: Generated once when policy is created
- **Configure in Mint Manager**: Set percentage and recipient address
- **Auto-Burned**: Handled automatically during minting process

## 📋 Shortcode

### `[cardano-mint]`
Creates a "MINT NOW" button with dual-signature minting modal.

**Attributes:**
- `mint-id` (required) - Collection ID or specific variant:
  - `"20"` = Random weighted selection from all variants (mystery box)
  - `"20-A"` = Only mint that specific variant
- `nftname` (optional) - Override display name
- `class` (optional) - CSS class for styling

**Examples:**
```
[cardano-mint mint-id="20"]
[cardano-mint mint-id="20-A" nftname="Rare Dragon NFT"]
[cardano-mint mint-id="25" class="custom-button"]
```

## 🎛️ Admin Pages

### Plugin Setup
- Configure Anvil API keys (mainnet/preprod)
- Set merchant wallet address for payments
- Add Pinata credentials (optional)
- Choose network environment
- Data cleanup options

### Mint Manager
Create new NFT collections:
- Collection ID + Variant (e.g., 20-A, 20-B)
- NFT image + Collection image (mystery box)
- Price in USD (auto-converted to ADA)
- Quantity and rarity percentage
- Generate time-locked policy IDs
- Set per-wallet mint limits
- Add CIP-25 metadata attributes
- Configure CIP-27 royalty info

### Active Mints
Manage existing mints:
- View by policy ID groups
- Edit variants and settings
- Track mints per policy
- Export/Import CSV (whitelist management)
- View mint history modal
- See unique minters count
- Delete individual or all mints

### Policy Wallet
- Generate new secure policy wallet
- ONE-TIME seed phrase display
- View current wallet addresses
- Copy payment/stake addresses
- Delete wallet (warning: cannot mint old NFTs)

## 🗄️ Database Tables

- `wp_cardanonftactivemints` - Mint configurations, variants, metadata
- `wp_cardano_policy_wallets` - Encrypted policy wallet credentials
- `wp_cardano_mint_wallets` - Per-wallet tracking with limits and history
- `wp_cardanonftmintcounts` - Legacy tracking (deprecated)

## 📐 Workflow Example

### Creating a 3-Variant Mystery Box Collection

1. **Setup**: Add Anvil keys, set network to preprod, add merchant address
2. **Policy Wallet**: Generate and SAVE the 24-word seed phrase
3. **Create Variant A** (parent):
   - Collection ID: 25, Variant: A
   - NFT Image: rare-dragon.png
   - Collection Image: mystery-box.png
   - Price: $50, Quantity: 10, Rarity: 10%
   - Mints Per Wallet: 3
   - Royalty: 5% to your wallet
4. **Generate Policy**: Click button → Save JSON → CIP-27 token auto-minted
5. **Create Variants B & C**: Same collection ID, different rarities (40%, 50%)
6. **Verify**: Rarities total 100% (10% + 40% + 50%)
7. **Add Shortcode**: `[cardano-mint mint-id="25"]`
8. **Test**: User sees mystery box → Mints → Random selection → NFT revealed
9. **Track**: View history, export CSV, manage whitelist

## 🔒 Security Features

- **Dual-Signature Transactions**: Customer + policy wallet
- **AES-256-CBC Encryption**: Policy wallet keys encrypted
- **WordPress Salt Integration**: Uses AUTH_KEY and SECURE_AUTH_SALT
- **CIP-30 Wallet Standard**: Eternl, Lace, Vespr, Nami, etc.
- **Nonce Verification**: All AJAX endpoints protected
- **Admin-Only Access**: Mint management restricted to admins

## ⚙️ Technical Stack

- **APIs**: ADA Anvil (transactions), Pinata (IPFS), Blockfrost (optional)
- **Cardano Standards**: CIP-25 (metadata), CIP-27 (royalties), CIP-30 (wallets)
- **Policy Wallet**: Deno-based Cardano Wallet CLI (bin/sign-tx.exe)
- **Encryption**: AES-256-CBC with PBKDF2 key derivation
- **Networks**: Mainnet and Preprod (testnet)
- **Requirements**: WordPress 5.0+, PHP 7.4+, CardanoPress plugin

## ⚠️ Critical Warnings

1. **Policy Wallet Seed**: Shown ONLY ONCE - write it down immediately
2. **Delete Policy Wallet**: Cannot mint old NFTs if deleted
3. **Test on Preprod**: Always test complete flow before mainnet
4. **Duplicate Policy IDs**: Same expiration + same wallet = same policy
5. **Metadata Length**: Keep image names under 63 characters
6. **Royalty Token**: Auto-minted ONCE per policy with first NFT
7. **CSV Import**: Replaces ALL records - export first to preserve data
8. **Blockchain Irreversibility**: No refunds possible

## 💡 Best Practices

- Always create Variant A first (parent variant)
- Mystery box image only editable on variant A in Active Mints
- Rarity percentages must total 100% for weighted random
- Save policy wallet seed offline immediately
- Test complete flow on preprod before mainnet
- CSV workflow: Export → Modify in Excel → Re-import
- Keep image file names short for IPFS compatibility
- Use HTTPS for production sites handling payments

## 🔧 Troubleshooting

- **"Policy ID already exists"**: Change expiration date
- **"Reached maximum mints"**: Wallet hit per-wallet limit
- **"Metadata too long"**: Shorten image file name
- **"Transaction failed"**: Check wallet has enough ADA (~2 ADA min)
- **"Policy wallet not found"**: Generate in Policy Wallet page
- **"Nonce verification failed"**: Clear browser cache
- **CSV import fails**: Verify correct CSV headers
- **Shortcode not working**: Check mint exists and is "Active"

## 📚 Documentation

- **How to Use**: Admin → Cardano Mint → How to Use (comprehensive guide)
- **POLICY_WALLET_ENCRYPTION.md**: Detailed encryption documentation
- **mvc-diagram.md**: MVC architecture overview
- **Browser Console**: Press F12 for transaction logs
- **WordPress Debug**: Enable WP_DEBUG for server logs

## 🎯 Use Cases

1. **NFT Drops**: Launch multi-variant collections with rarity
2. **Mystery Boxes**: Blind reveals with collection images
3. **Whitelist Mints**: Pre-authorize VIP wallets via CSV
4. **Limited Editions**: Per-wallet mint limits enforcement
5. **Royalty NFTs**: Automated CIP-27 royalty tokens
6. **Analytics**: Track unique minters and engagement
7. **Event Tickets**: Quantity limits and time-locked policies

## 📦 Installation

1. Upload plugin to `/wp-content/plugins/cardano-mint-pay/`
2. Activate via WordPress admin
3. Configure API keys in Plugin Setup
4. Generate policy wallet (SAVE SEED PHRASE!)
5. Create first mint collection
6. Add shortcode to your page

## 🆘 Support

For technical support, check documentation files or enable WordPress debug logging.

---

**Version**: 3.0.0
**Author**: PB_Anvil
**License**: MIT
**Requires**: WordPress 5.0+, PHP 7.4+, CardanoPress
